﻿using System.Collections.Generic;
using System.Collections.ObjectModel;

namespace DirtbagSampler.ViewModels;

public class MyLibraryPageViewModel : BaseViewModel
{
	MusicItemViewModel selectedMusicItem;

	public MyLibraryPageViewModel()
	{

		ObservableCollection<MusicItemViewModel> _temp = new ObservableCollection<MusicItemViewModel>();
		_temp.Add(new MusicItemViewModel("IRON MAIDEN", "Samples", "patch_iron_maiden.png", "ACES HIGH.mp3", "POWERSLAVE.mp3", "THE NUMBER OF THE BEAST.mp3", "STOP.mp3"));
		_temp.Add(new MusicItemViewModel("METALLICA", "Samples", "patch_metallica.png", "FOR WHOM THE BELLS TOLLS.mp3", "STOP.mp3", "STOP.mp3", "STOP.mp3"));
		_temp.Add(new MusicItemViewModel("JUDAS PRIEST", "Samples", "patch_judas_priest.png", "BREAKING THE LAW.mp3", "STOP.mp3", "STOP.mp3", "STOP.mp3"));
		_temp.Add(new MusicItemViewModel("ACCEPT", "Samples", "patch_accept2.png", "FAST AS A SHARK.mp3", "STOP.mp3", "STOP.mp3", "STOP.mp3"));
		_temp.Add(new MusicItemViewModel("DIO", "Samples", "patch_dio.png", "HOLY DIVER.mp3", "STOP.mp3", "STOP.mp3", "STOP.mp3"));
		_temp.Add(new MusicItemViewModel("SLAYER", "Samples", "patch_slayer.png", "INTRO REIGN IN BLOOD.mp3", "OUTRO REIGN IN BLOOD.mp3", "STOP.mp3", "STOP.mp3"));
		_temp.Add(new MusicItemViewModel("MANOWAR", "Samples", "patch_manowar.png", "HEART OF STEEL.mp3", "STOP.mp3", "STOP.mp3", "STOP.mp3"));
		_temp.Add(new MusicItemViewModel("ANTHRAX", "Samples", "patch_anthrax.png", "MAD HOUSE.mp3", "STOP.mp3", "STOP.mp3", "STOP.mp3"));
		_temp.Add(new MusicItemViewModel("MEGADETH", "Samples", "patch_megadeth.png", "SYMPHONY OF DESTRUCTION.mp3", "STOP.mp3", "STOP.mp3", "STOP.mp3"));

		Music3 = new ObservableCollection<MusicItemViewModel>(_temp);
	}

	//public ObservableCollection<MusicItemViewModel> Music { get; }
	//public ObservableCollection<MusicItemViewModel> Music2 { get; }
	
	public ObservableCollection<MusicItemViewModel> Music3 { get; }

	public MusicItemViewModel SelectedMusicItem
	{
		get => selectedMusicItem;
		set
		{
			selectedMusicItem = value;
			NotifyPropertyChanged();

			OnMusicItemSelected();
		}
	}

	async void OnMusicItemSelected()
	{
		await Shell.Current.GoToAsync(
			Routes.MusicPlayer.RouteName,
			new Dictionary<string, object>
			{
				[Routes.MusicPlayer.Arguments.Music] = SelectedMusicItem
			});
	}
}
